package ru.yandex.direct.core.entity.contentpromotion;

import javax.annotation.Nonnull;

import com.fasterxml.jackson.annotation.JsonProperty;

public class DefaultContentPromotionMeta<T extends DefaultContentPromotionMeta> {

    @JsonProperty("content_id")
    @Nonnull
    private Long contentId;

    @JsonProperty("url")
    @Nonnull
    private String url;

    @JsonProperty("preview_url")
    @Nonnull
    private String previewUrl;

    public String getUrl() {
        return url;
    }

    public T withUrl(String url) {
        this.url = url;
        return (T)this;
    }

    public String getPreviewUrl() {
        return previewUrl;
    }

    public T withPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
        return (T)this;
    }

    public Long getContentId() {
        return contentId;
    }

    public T withContentId(Long contentId) {
        this.contentId = contentId;
        return (T)this;
    }
}
