package ru.yandex.direct.core.entity.contentpromotion.type;

import java.math.BigInteger;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;

import ru.yandex.direct.core.entity.contentpromotion.ContentPromotionContentBasicData;
import ru.yandex.direct.core.entity.contentpromotion.ContentPromotionSingleObjectRequest;
import ru.yandex.direct.core.entity.contentpromotion.model.ContentPromotionContent;
import ru.yandex.direct.core.entity.contentpromotion.model.ContentPromotionContentType;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

/**
 * Обработчик продвигаемого контента (таблицы ppc.content_promotion и ppc.content_promotion_video)
 * и групп объявлений, ему соответствующих (ppc.adgroup_content_promotion)
 * Должен быть реализован для каждого типа контента
 */
public interface AbstractContentPromotionCoreTypeSupport {
    /**
     * Тип продвигаемого контента, соответствующий данному обработчику
     */
    ContentPromotionContentType getType();

    /**
     * Посчитать значение хэша по json (хэш от content_promotion.metadata или content_promotion_video.video_metadata,
     * значение хэша хранится в  content_promotion.metadata_hash
     * и content_promotion_video.video_metadata_hash соответственно)
     */
    BigInteger calcMetadataHash(String metadataJson);


    /**
     * Вытащить из ссылки внешний идентификатор контента
     */
    Map<Integer, String> calcExternalIds(Map<Integer, ContentPromotionSingleObjectRequest> requestsByIndex);

    /**
     * Построение экземпляра ContentPromotionContentBasicData по данным из базы
     *
     */
    @Nonnull
    Map<Integer, ContentPromotionContentBasicData> buildBasicDataFromDbData(
            Map<Integer, ContentPromotionContent> contentByIndex,
            Map<Integer, ContentPromotionSingleObjectRequest> requests);

    /**
     * Вернуть экземпляр ContentPromotionContentBasicData, не встречающийся в базе, с помощью похода во внешний сервис
     */
    @Nonnull
    Map<String, ContentPromotionContentBasicData> getBasicDataFromExternalRequest(
            Map<Integer, String> externalIdsByIndex,
            Map<Integer, ContentPromotionSingleObjectRequest> requestsByIndex);

    /**
     * Валидировать экзмепляр ContentPromotionContentBasicData, полученный при походе во внешний сервис
     */
    <T extends ContentPromotionContentBasicData> ValidationResult<List<T>, Defect> validateBasicDataFromExternalService(
            List<T> contentPromotionContentBasicData);

    /**
     * Валидировать экзмепляр ContentPromotionContentBasicData, полученный при походе в базу
     */
    <T extends ContentPromotionContentBasicData> ValidationResult<List<T>, Defect> validateBasicDataFromDb(
            List<T> contentPromotionContentBasicData);
}
