package ru.yandex.direct.core.entity.contentpromotion.type.collection;

import javax.annotation.Nullable;

import ru.yandex.direct.env.EnvironmentType;

public class ContentPromotionCollectionUtils {
    private static final String PROD_PREFIX = "https://avatars.mds.yandex.net/get-pdb-preview/";
    private static final String TESTING_PREFIX = "https://avatars-int.mds.yandex.net/get-pdb-teasers-test/";

    /**
     * Формирование ссылки на превью
     * В зависимости от типа окружения (тестовые или продовые коллекции) ссылка формируется по разному
     *
     * @param thumbId         - thumbId из metadata.json, приходящего из ручки коллекций
     * @param environmentType - тип окружения Директа
     * @return ссылка на превью
     */
    public static String convertToPreviewUrl(@Nullable String thumbId, EnvironmentType environmentType) {
        String previewUrlPrefix = environmentType.isProductionOrPrestable() ? PROD_PREFIX : TESTING_PREFIX;
        return thumbId == null ? null : previewUrlPrefix + thumbId + "/thumb";
    }
}
