package ru.yandex.direct.core.entity.contentpromotion.type.collection;

import ru.yandex.direct.core.entity.contentpromotion.ContentPromotionContentBasicData;
import ru.yandex.direct.core.entity.contentpromotion.model.ContentPromotionContentType;

public class ContentPromotionContentCollectionData implements
        ContentPromotionContentBasicData<CollectionsContentPromotionMeta> {
    private String metadataJson;
    private String previewUrl;
    private String url;
    private boolean isAccessible;
    private int cardsCount;

    public ContentPromotionContentCollectionData(String metadataJson, String previewUrl, String url,
                                                 boolean isAccessible, int cardsCount) {
        this.metadataJson = metadataJson;
        this.previewUrl = previewUrl;
        this.url = url;
        this.isAccessible = isAccessible;
        this.cardsCount = cardsCount;
    }

    public ContentPromotionContentCollectionData(String metadataJson, String previewUrl, String url,
                                                 int cardsCount) {
        this(metadataJson, previewUrl, url, true, cardsCount);
    }

    public String getMetadataJson() {
        return metadataJson;
    }

    public String getPreviewUrl() {
        return previewUrl;
    }

    public String getUrl() {
        return url;
    }

    @Override
    public boolean isAccessible() {
        return isAccessible;
    }

    @Override
    public ContentPromotionContentType getContentType() {
        return ContentPromotionContentType.COLLECTION;
    }

    public int getCardsCount() {
        return cardsCount;
    }

    public CollectionsContentPromotionMeta toWebResponse(Long contentId) {
        return new CollectionsContentPromotionMeta()
                .withContentId(contentId)
                .withUrl(getUrl())
                .withPreviewUrl(getPreviewUrl());
    }
}
