package ru.yandex.direct.core.entity.contentpromotion.type.eda;

import javax.annotation.Nonnull;

import ru.yandex.direct.core.entity.contentpromotion.ContentPromotionContentBasicData;
import ru.yandex.direct.core.entity.contentpromotion.model.ContentPromotionContentType;

public class ContentPromotionContentEdaData implements ContentPromotionContentBasicData<EdaContentPromotionMeta> {
    private String metadataJson;
    private String url;

    public ContentPromotionContentEdaData(String metadataJson, String url) {
        this.metadataJson = metadataJson;
        this.url = url;
    }

    @Override
    public String getMetadataJson() {
        return metadataJson;
    }

    @Override
    public String getPreviewUrl() {
        return null;
    }

    @Override
    public String getUrl() {
        return url;
    }

    @Override
    public boolean isAccessible() {
        return true;
    }

    @Override
    public ContentPromotionContentType getContentType() {
        return ContentPromotionContentType.EDA;
    }

    @Nonnull
    @Override
    public EdaContentPromotionMeta toWebResponse(Long contentId) {
        return new EdaContentPromotionMeta()
                .withContentId(contentId)
                .withUrl(getUrl())
                .withPreviewUrl(getPreviewUrl());
    }
}
