package ru.yandex.direct.core.entity.contentpromotion.type.eda;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.contentpromotion.ContentPromotionContentBasicData;
import ru.yandex.direct.core.entity.contentpromotion.ContentPromotionSingleObjectRequest;
import ru.yandex.direct.core.entity.contentpromotion.model.ContentPromotionContent;
import ru.yandex.direct.core.entity.contentpromotion.model.ContentPromotionContentType;
import ru.yandex.direct.core.entity.contentpromotion.type.DefaultContentPromotionCoreTypeSupport;
import ru.yandex.direct.utils.JsonUtils;

import static com.google.common.base.Preconditions.checkState;


@Component
@ParametersAreNonnullByDefault
public class ContentPromotionEdaCoreTypeSupport extends DefaultContentPromotionCoreTypeSupport {

    @Override
    public ContentPromotionContentType getType() {
        return ContentPromotionContentType.EDA;
    }

    @Nonnull
    @Override
    public ContentPromotionContentBasicData buildSingleBasicDataFromDbData(
            @Nonnull ContentPromotionContent content,
            @Nonnull ContentPromotionSingleObjectRequest request) {
        checkState(content.getUrl().equals(request.getUrl()),
                "md5 hash in content_promotion eda url collision " + content.getUrl() + " " +
                        request.getUrl());
        return new ContentPromotionContentEdaData(content.getMetadata(), content.getUrl());
    }

    @Override
    public ContentPromotionContentBasicData getSingleBasicDataFromExternalRequest(
            String externalId,
            ContentPromotionSingleObjectRequest request) {
        Map<String, String> metadata = Map.of("service_url", request.getUrl());
        String metadataJson = JsonUtils.toJson(metadata);
        return new ContentPromotionContentEdaData(metadataJson, request.getUrl());
    }
}
