package ru.yandex.direct.core.entity.contentpromotion.type.service;

import javax.annotation.Nonnull;

import ru.yandex.direct.core.entity.contentpromotion.ContentPromotionContentBasicData;
import ru.yandex.direct.core.entity.contentpromotion.model.ContentPromotionContentType;

public class ContentPromotionContentServiceData implements
        ContentPromotionContentBasicData<ServicesContentPromotionMeta> {
    private String metadataJson;
    private String url;

    public ContentPromotionContentServiceData(String metadataJson, String url) {
        this.metadataJson = metadataJson;
        this.url = url;
    }

    @Override
    public String getMetadataJson() {
        return metadataJson;
    }

    @Override
    public String getPreviewUrl() {
        return null;
    }

    @Override
    public String getUrl() {
        return url;
    }

    @Override
    public boolean isAccessible() {
        return true;
    }

    @Override
    public ContentPromotionContentType getContentType() {
        return ContentPromotionContentType.SERVICE;
    }

    @Nonnull
    @Override
    public ServicesContentPromotionMeta toWebResponse(Long contentId) {
        return new ServicesContentPromotionMeta()
                .withContentId(contentId)
                .withUrl(getUrl())
                .withPreviewUrl(getPreviewUrl());
    }
}
