package ru.yandex.direct.core.entity.contentpromotion.type.video;

import ru.yandex.direct.core.entity.contentpromotion.ContentPromotionContentBasicData;
import ru.yandex.direct.core.entity.contentpromotion.model.ContentPromotionContentType;

public class ContentPromotionContentVideoData implements
        ContentPromotionContentBasicData<VideoContentPromotionMeta> {
    private String metadataJson;
    private String previewUrl;
    private String url;
    private boolean isAccessible;
    private String title;
    private String description;

    public ContentPromotionContentVideoData(String metadataJson, String previewUrl, String url,
                                            boolean isAccessible, String title, String description) {
        this.metadataJson = metadataJson;
        this.previewUrl = previewUrl;
        this.url = url;
        this.isAccessible = isAccessible;
        this.title = title;
        this.description = description;
    }

    public ContentPromotionContentVideoData(String metadataJson, String previewUrl, String url,
                                            String title, String description) {
        this(metadataJson, previewUrl, url, true, title, description);
    }

    public String getMetadataJson() {
        return metadataJson;
    }

    public String getPreviewUrl() {
        return previewUrl;
    }

    public String getUrl() {
        return url;
    }

    public boolean isAccessible() {
        return isAccessible;
    }

    @Override
    public ContentPromotionContentType getContentType() {
        return ContentPromotionContentType.VIDEO;
    }

    public String getTitle() {
        return title;
    }

    public String getDescription() {
        return description;
    }

    public VideoContentPromotionMeta toWebResponse(Long contentId) {
        return new VideoContentPromotionMeta()
                .withContentId(contentId)
                .withUrl(getUrl())
                .withTitle(getTitle())
                .withDescription(getDescription())
                .withPreviewUrl(getPreviewUrl());
    }
}
