package ru.yandex.direct.core.entity.contentpromotion.validation.converters;

import java.util.List;

import javax.annotation.Nullable;

import one.util.streamex.EntryStream;

import ru.yandex.direct.core.entity.contentpromotion.DefaultContentPromotionMeta;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.Path;
import ru.yandex.direct.validation.result.PathNode;
import ru.yandex.direct.validation.result.ValidationResult;

import static com.google.common.base.Preconditions.checkState;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

/**
 * Конвертация веб-результата добавления контента в адаптированный под апи
 * Конвертирует внутри себя экземпляры DefaultContentPromotionMeta в экземпляры Long путём извлечения айдишников
 */
public class ToApiResultConverter {
    public static ValidationResult<List<Long>, Defect> convertToApiValidationResult(
            ValidationResult<List<DefaultContentPromotionMeta>, Defect> vr) {
        return vr.transformUnchecked(new ToApiResponseTransformer());
    }

    /**
     * Трансформирует значение внутри ValidationResult в зависимости от пути
     * Для пустого пути конвертируем весь список oldValue поэлементно
     * Для пути длины один, соответствующего индексу, конвертируем один элемент DefaultContentPromotionMeta
     * в Long
     */
    private static class ToApiResponseTransformer implements ValidationResult.ValidationResultTransformer<Defect> {
        @SuppressWarnings("unchecked")
        @Override
        public <OV> Object transformValue(Path path, @Nullable OV oldValue) {
            if (oldValue == null) {
                return oldValue;
            }
            if (path.isEmpty()) {
                checkState(oldValue instanceof List, "value has to be instance of List");
                List<DefaultContentPromotionMeta> castedList = (List<DefaultContentPromotionMeta>) oldValue;
                return EntryStream.of(castedList)
                        .mapKeyValue((ind, val) -> ifNotNull(val, t -> t.getContentId()))
                        .toList();
            } else if (path.getNodes().size() == 1 && path.getNodes().get(0) instanceof PathNode.Index &&
                    oldValue instanceof DefaultContentPromotionMeta) {
                return ((DefaultContentPromotionMeta) oldValue).getContentId();
            } else {
                return oldValue;
            }
        }
    }
}
