package ru.yandex.direct.core.entity.contentpromotion.validation.defects;

import ru.yandex.direct.core.entity.contentpromotion.validation.ContentPromotionConstants;
import ru.yandex.direct.validation.defect.params.NumberDefectParams;
import ru.yandex.direct.validation.result.Defect;

public class ContentPromotionDefects {
    private ContentPromotionDefects() {
    }

    public static Defect notEnoughCardsInExistingCollection() {
        return new Defect<>(ContentPromotionDefectIds.NumberDefectIds.NOT_ENOUGH_CARDS_IN_EXISTING_COLLECTION,
                new NumberDefectParams().withMin(ContentPromotionConstants.MINIMAL_CARD_COUNT));
    }

    public static Defect notEnoughCardsInNewCollection() {
        return new Defect<>(ContentPromotionDefectIds.NumberDefectIds.NOT_ENOUGH_CARDS_IN_NEW_COLLECTION,
                new NumberDefectParams().withMin(ContentPromotionConstants.MINIMAL_CARD_COUNT));
    }

    public static Defect contentNotFound() {
        return new Defect<>(ContentPromotionDefectIds.GeneralDefectIds.CONTENT_PROMOTION_NOT_FOUND);

    }

    public static Defect contentInaccessible() {
        return new Defect<>(ContentPromotionDefectIds.GeneralDefectIds.CONTENT_PROMOTION_INACCESSIBLE);

    }

    public static Defect contentPromotionTypeIsNotSupported() {
        return new Defect<>(ContentPromotionDefectIds.GeneralDefectIds.CONTENT_PROMOTION_TYPE_IS_NOT_SUPPORTED);
    }
}
