package ru.yandex.direct.core.entity.contentsegment.translation;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.bundle.TranslationStub;


public interface ContentCategoryTranslations extends TranslationBundle {
    ContentCategoryTranslations INSTANCE = I18NBundle.implement(ContentCategoryTranslations.class);

    @TranslationStub("Авто")
    Translatable content_genre_auto_name();

    @TranslationStub("Видео и сайты с обзорами автомобилей, автомобильных соревнований и автовыставок, автоуслуги, " +
            "обучение вождению.")
    Translatable content_genre_auto_description();

    @TranslationStub("Бизнес")
    Translatable content_genre_industry_name();

    @TranslationStub("Сайты и видео с информацией, в том числе образовательной, об открытии и автоматизации бизнеса, " +
            "бирже, инвестициях, рекламе и её настройках, маркетинге, обсуждение сельского хозяйства, биомедицины, " +
            "строительства, логистики, коммерческого программного обеспечения. \n" +
            "Исключения: информация про психологически тренинги и обучение, карьеру, найм и поиск работы, материалы " +
            "о политике, юриспруденции (см. «Закон, политика и право») и военной промышленности.")
    Translatable content_genre_industry_description();

    @TranslationStub("Путешествия")
    Translatable content_genre_travel_name();

    @TranslationStub("Материалы об активном и детском отдыхе, организации туров и экскурсий, " +
            "информация об оформлении заграничных паспортов и виз.")
    Translatable content_genre_travel_description();

    @TranslationStub("Зарубежный туризм")
    Translatable content_genre_foreign_tourism_name();

    @TranslationStub("Материалы о путешествиях в другие страны.")
    Translatable content_genre_foreign_tourism_description();

    @TranslationStub("Отечественный туризм")
    Translatable content_genre_domestic_tourism_name();

    @TranslationStub("Материалы о путешествиях по России.")
    Translatable content_genre_domestic_tourism_description();

    @TranslationStub("Авиабилеты и гостиницы")
    Translatable content_genre_flights_name();

    @TranslationStub("Материалы об авиакомпаниях, гостиницах, отелях и кемпингах, подборе авиабилетов.")
    Translatable content_genre_flights_description();

    @TranslationStub("Дом и сад")
    Translatable content_genre_house_name();

    @TranslationStub("Материалы о ремонте, внутренней отделке дома, бытовой технике, садоводстве, " +
            "озеленении и обустройстве участка.")
    Translatable content_genre_house_description();

    @TranslationStub("Интерьер")
    Translatable content_genre_interior_name();

    @TranslationStub("Материалы об обустройстве дома, передачи и обзоры про интерьер.")
    Translatable content_genre_interior_description();

    @TranslationStub("Дача и сад")
    Translatable content_genre_garden_name();

    @TranslationStub("Материалы о ведении хозяйства за городом: строительство и отделка садового участка.")
    Translatable content_genre_garden_description();

    @TranslationStub("Домашние животные")
    Translatable content_genre_pets_name();

    @TranslationStub("Видео и сайты, посвященные домашним животным: собакам, кошкам, лошадям, грызунам, птицам, " +
            "пресмыкающимся и земноводным, экзотическим животным, аквариумистике и рыбам.")
    Translatable content_genre_pets_description();

    @TranslationStub("Кошки")
    Translatable content_genre_cats_name();

    @TranslationStub("Видео и сайты про кошек: уход, выставки и прочее.")
    Translatable content_genre_cats_description();

    @TranslationStub("Собаки")
    Translatable content_genre_dogs_name();

    @TranslationStub("Видео и сайты про собак: уход, выставки и прочее.")
    Translatable content_genre_dogs_description();

    @TranslationStub("Еда и напитки")
    Translatable content_genre_food_name();

    @TranslationStub("Сайты и видео с материалами о кулинарии и питании, барах и ресторанах, кухнях различных стран мира. ")
    Translatable content_genre_food_description();

    @TranslationStub("Рестораны и бары")
    Translatable content_genre_bars_name();

    @TranslationStub("Сайты и видео о ресторанах среднего и высокого ценового сегмента и барах.")
    Translatable content_genre_bars_description();

    @TranslationStub("Кулинария")
    Translatable content_genre_cooking_name();

    @TranslationStub("Материалы о приготовлении еды, рецепты, кулинарные передачи.")
    Translatable content_genre_cooking_description();

    @TranslationStub("Кафе и фастфуд")
    Translatable content_genre_cafe_name();

    @TranslationStub("Материалы о ресторанах быстрого питания.")
    Translatable content_genre_cafe_description();

    @TranslationStub("Правильное питание")
    Translatable content_genre_healthy_food_name();

    @TranslationStub("Материалы по диетологии, кулинарии правильного питания, фитнес-меню.")
    Translatable content_genre_healthy_food_description();

    @TranslationStub("Закон, политика и право")
    Translatable content_genre_law_name();

    @TranslationStub("Площадки с новостными материалами о законах, политике и праве, информацией о выборах и " +
            "юриспруденции. Исключение: военные новости.")
    Translatable content_genre_law_description();

    @TranslationStub("Игры")
    Translatable content_genre_games_name();

    @TranslationStub("Площадки с обзорами и обсуждениями компьютерных, настольных и карточных игр.")
    Translatable content_genre_games_description();

    @TranslationStub("Киберспорт")
    Translatable content_genre_esport_name();

    @TranslationStub("Материалы с тематических событий в области киберспорта.")
    Translatable content_genre_esport_description();

    @TranslationStub("Обзоры и летсплеи")
    Translatable content_genre_letsplay_name();

    @TranslationStub("Обзоры и прохождения компьютерных игр.")
    Translatable content_genre_letsplay_description();

    @TranslationStub("Интернет и телекоммуникации")
    Translatable content_genre_internet_name();

    @TranslationStub("Площадки с новостями и обзорами интернет-технологий, телекоммуникаций и операторов связи. " +
            "Исключение: информация о работе в интернете.")
    Translatable content_genre_internet_description();

    @TranslationStub("Искусство и развлечения")
    Translatable content_genre_art_name();

    @TranslationStub("Сайты и видео о живописи, скульптуре, музыке, кино, архитектуре и театре.")
    Translatable content_genre_art_description();

    @TranslationStub("Книги и литература")
    Translatable content_genre_literature_name();

    @TranslationStub("Материалы об отечественной и зарубежной литературе различных жанров.")
    Translatable content_genre_literature_description();

    @TranslationStub("Отечественная литература")
    Translatable content_genre_domestic_literature_name();

    @TranslationStub("Книги отечественных писателей, обзоры, рецензии, экранизации, тематические телепередачи.")
    Translatable content_genre_domestic_literature_description();

    @TranslationStub("Зарубежная литература")
    Translatable content_genre_foreign_literature_name();

    @TranslationStub("Произведения зарубежных писателей, обзоры, рецензии, экранизации, тематические телепередачи.")
    Translatable content_genre_foreign_literature_description();

    @TranslationStub("Детская литература")
    Translatable content_genre_childrens_literature_name();

    @TranslationStub("Произведения детских писателей, обзоры, рецензии, экранизации детской литературы, тематические " +
            "телепередачи о литературных произведениях для детей.")
    Translatable content_genre_childrens_literature_description();

    @TranslationStub("Компьютеры и электроника")
    Translatable content_genre_computers_name();

    @TranslationStub("Новостные материалы, статьи и обзоры электроники, компьютеров и комплектующих, краш-тестов " +
            "программного обеспечения, операционных систем, прошивок, телефонов, приложений для телефонов, фото- и " +
            "видеокамер, аудиосистем. Исключение: информация про бытовую технику (см. «Дом и сад»), интернет, " +
            "телекоммуникации, информационные технологии и компьютерные игры (см. «Игры»).")
    Translatable content_genre_computers_description();

    @TranslationStub("Красота и здоровье")
    Translatable content_genre_beauty_name();

    @TranslationStub("Сайты и видео с обзорами косметики, бьюти-блоги, информация о здоровье, фитнес-упражнениях. " +
            "Исключение: новостные материалы, любые статьи про медицину, правильное питание и диеты, материалы про " +
            "спорт (см. «Спорт»).")
    Translatable content_genre_beauty_description();

    @TranslationStub("Фитнес")
    Translatable content_genre_fitness_name();

    @TranslationStub("Материалы о различных направлениях фитнеса, программах тренировок.")
    Translatable content_genre_fitness_description();

    @TranslationStub("Здоровье")
    Translatable content_genre_health_name();

    @TranslationStub("Материалы о здоровье, в том числе телепередачи, за исключением медицины.")
    Translatable content_genre_health_description();

    @TranslationStub("Косметика")
    Translatable content_genre_cosmetics_name();

    @TranslationStub("Материалы об уходовой косметике, макияже и парфюмерии.")
    Translatable content_genre_cosmetics_description();

    @TranslationStub("Люди и общество")
    Translatable content_genre_society_name();

    @TranslationStub("Сайты, форумы и видео о взаимоотношениях (знакомства, свадьбы, разводы), этнической специфике, " +
            "выдающихся людях и их биографиях. Исключение: любые новостные материалы (см. «Новости»).")
    Translatable content_genre_society_description();

    @TranslationStub("Наука")
    Translatable content_genre_science_name();

    @TranslationStub("Площадки со статьями, лекциями и обзорами о науке, например, биологии, химии, геологии, " +
            "физике, географии, ботанике, метеорологии.")
    Translatable content_genre_science_description();

    @TranslationStub("Популярная наука")
    Translatable content_genre_popular_science_name();

    @TranslationStub("Передачи о популяризации науки, документальные сериалы, другие тематические материалы.")
    Translatable content_genre_popular_science_description();

    @TranslationStub("Недвижимость")
    Translatable content_genre_estate_name();

    @TranslationStub("Материалы о рынке недвижимости и строительстве.")
    Translatable content_genre_estate_description();

    @TranslationStub("Новости")
    Translatable content_genre_news_name();

    @TranslationStub("Площадки с новостями, записями новостных программ, новостными репортажами. Видео с " +
            "обзорами событий.")
    Translatable content_genre_news_description();

    @TranslationStub("Работа")
    Translatable content_genre_job_name();

    @TranslationStub("Площадки с информацией о рынке труда, карьере, поиске и ярмарках работы, курсах повышения " +
            "квалификации и профориентации. Исключение: видео и сайты об образовании (см. «Образование») и " +
            "военной карьере.")
    Translatable content_genre_job_description();

    @TranslationStub("Образование")
    Translatable content_genre_education_name();

    @TranslationStub("Материалы о дошкольном, внешкольном, среднем и высшем образовании, " +
            "изучении иностранных языков, курсах и репетиторах. ")
    Translatable content_genre_education_description();

    @TranslationStub("Спорт")
    Translatable content_genre_sport_name();

    @TranslationStub("Площадки с материалами о разных видах спорта и спортивных событиях.")
    Translatable content_genre_sport_description();

    @TranslationStub("Бодибилдинг")
    Translatable content_genre_bodybuilding_name();

    @TranslationStub("Всё о бодибилдинге: фильмы, новости, передачи, обзоры турниров и чемпионатов.")
    Translatable content_genre_bodybuilding_description();

    @TranslationStub("Футбол")
    Translatable content_genre_football_name();

    @TranslationStub("Всё о футболе, мини-футболе и футболистах: фильмы, новости, передачи, обзоры турниров и " +
            "чемпионатов.")
    Translatable content_genre_football_description();

    @TranslationStub("Хоккей")
    Translatable content_genre_hockey_name();

    @TranslationStub("Всё о хоккее и хоккеистах: фильмы, новости, передачи, обзоры турниров и чемпионатов.")
    Translatable content_genre_hockey_description();

    @TranslationStub("Баскетбол")
    Translatable content_genre_basketball_name();

    @TranslationStub("Всё о баскетболе, стритболе и баскетболистах: фильмы, новости, передачи, обзоры турниров " +
            "и чемпионатов.")
    Translatable content_genre_basketball_description();

    @TranslationStub("Единоборства")
    Translatable content_genre_martial_arts_name();

    @TranslationStub("Всё о единоборствах: фильмы, новости, передачи, обзоры турниров " +
            "и чемпионатов.")
    Translatable content_genre_martial_arts_description();

    @TranslationStub("Экстремальные виды спорта")
    Translatable content_genre_extreme_name();

    @TranslationStub("Всё об экстремальных видах спорта и о занятиях спортом на открытом воздухе: фильмы, новости, " +
            "передачи, обзоры турниров и чемпионатов.")
    Translatable content_genre_extreme_description();

    @TranslationStub("Финансы")
    Translatable content_genre_finance_name();

    @TranslationStub("Площадки, которые посвящены финансовой сфере, в том числе планированию, прогнозированию, " +
            "инвестированию, кредитованию и страхованию, акциям, фондовым рынкам, пенсиям и налогам.\n" +
            "Исключения: информация о курсах повышения квалификации и обучающие лекции по экономике и " +
            "финансовой грамотности (см. «Наука»).")
    Translatable content_genre_finance_description();

    @TranslationStub("Хобби и отдых")
    Translatable content_genre_relaxation_name();

    @TranslationStub("Площадки с информацией, обзорами и обсуждениями рукоделия (например, вышивки, скрапбукинга, " +
            "изготовления свечей), орнитологии, коллекционирования, рисования и покраски, игры на гитаре, " +
            "домашней видео- и звукозаписи, фотографии, а так же активного отдыха и товаров для него. Исключение: " +
            "видео и сайты о туризме (см. «География и путешествия»).")
    Translatable content_genre_relaxation_description();

    @TranslationStub("Активный отдых")
    Translatable content_genre_leisure_name();

    @TranslationStub("Обзоры подвижных игр и товаров для активного отдыха. Исключение: видео и сайты о туризме.")
    Translatable content_genre_leisure_description();

    @TranslationStub("Хобби")
    Translatable content_genre_hobby_name();

    @TranslationStub("Сайты и видео о рукоделии (вышивке, скрапбукинге, изготовлении свечей, мыла), орнитологии, " +
            "коллекционировании, рисовании, покраске, игре на гитаре, домашней видео- и звукозаписи, фотографии.")
    Translatable content_genre_hobby_description();

    @TranslationStub("Шоппинг и покупки")
    Translatable content_genre_shopping_name();

    @TranslationStub("Сайты и видео, посвященные одежде и обуви, бижутерии и ювелирным изделиям, продуктам питания. " +
            "Исключения: информация о моде и модных тенденциях, электронике (см. «Компьютеры и электроника»), " +
            "товарах для садоводства, строительства, обустройства участков и домашнего интерьера (см. «Дом и сад»).")
    Translatable content_genre_shopping_description();

    @TranslationStub("Одежда")
    Translatable content_genre_clothes_name();

    @TranslationStub("Материалы об обуви, одежде, головных уборах, аксессуарах и показах мод.")
    Translatable content_genre_clothes_description();

    @TranslationStub("Товары для дома")
    Translatable content_genre_household_products_name();

    @TranslationStub("Материалы о товарах для дома, за исключением электроники, товаров для обустройства загородной " +
            "жизни и декора.")
    Translatable content_genre_household_products_description();

    @TranslationStub("Продукты")
    Translatable content_genre_products_name();

    @TranslationStub("Материалы о продуктах питания: обзоры, фильмы, передачи.")
    Translatable content_genre_products_description();

    @TranslationStub("Семья и дети")
    Translatable content_genre_family_name();

    @TranslationStub("Сайты и видео о беременности, воспитании малышей и подростков, детях с особыми потребностями, " +
            "детских садах и дошкольных учреждениях. Площадки с детскими фильмами и мультфильмами. " +
            "Исключение: информация о школьном образовании.")
    Translatable content_genre_family_description();

    @TranslationStub("Контент для родителей")
    Translatable content_genre_female_name();

    @TranslationStub("Сайты и видео о беременности, воспитании детей и подростков, школах и дошкольных учреждениях.")
    Translatable content_genre_female_description();

    @TranslationStub("Контент для детей")
    Translatable content_genre_childrens_name();

    @TranslationStub("Площадки с детскими фильмами, мультфильмами и играми.")
    Translatable content_genre_childrens_description();

    @TranslationStub("Остальное")
    Translatable content_genre_rest_name();

    @TranslationStub("Остальное")
    Translatable content_genre_rest_description();

    @TranslationStub("Бытовые советы")
    Translatable content_genre_rest_house_name();

    @TranslationStub("Советы по уборке и поддержанию порядка, ремонт своими руками, рекомендации по садоводству.")
    Translatable content_genre_rest_house_description();

    @TranslationStub("Статьи о животных")
    Translatable content_genre_rest_pets_name();

    @TranslationStub("Новости, советы по уходу и содержанию питомцев.")
    Translatable content_genre_rest_pets_description();

    @TranslationStub("Новости и советы")
    Translatable content_genre_rest_food_name();

    @TranslationStub("Материалы о еде и пищевом поведении, тематические исследования и рекомендации.")
    Translatable content_genre_rest_food_description();

    @TranslationStub("Онлайн-игры")
    Translatable content_genre_rest_games_name();

    @TranslationStub("Казуальные и обучающие игры, аркады, стратегии и другие категории игр.")
    Translatable content_genre_rest_games_description();

    @TranslationStub("Литература для учебы и отдыха")
    Translatable content_genre_rest_literature_name();

    @TranslationStub("Площадки с рассказами, литературой для учебы, краткими изложениями произведений, рецензиями.")
    Translatable content_genre_rest_literature_description();

    @TranslationStub("Новости и советы")
    Translatable content_genre_rest_beauty_name();

    @TranslationStub("Полезные и развлекательные статьи и подборки на тему красоты и здоровья.")
    Translatable content_genre_rest_beauty_description();

    @TranslationStub("Научные статьи")
    Translatable content_genre_rest_science_name();

    @TranslationStub("Сайты с новостями о научных открытиях, историческими фактами и исследованиями.")
    Translatable content_genre_rest_science_description();

    @TranslationStub("Новости и советы")
    Translatable content_genre_rest_travel_name();

    @TranslationStub("Статьи о путешествиях и туризме, тревел-блоги и прочее.")
    Translatable content_genre_rest_travel_description();

    @TranslationStub("Семейная жизнь")
    Translatable content_genre_rest_family_name();

    @TranslationStub("Статьи о семейном быте и отношениях, форумы о семейной жизни.")
    Translatable content_genre_rest_family_description();

    @TranslationStub("Новости из мира спорта")
    Translatable content_genre_rest_sport_name();

    @TranslationStub("Сайты со спортивными новостями, турнирные таблицы, расписания чемпионатов, интервью со спортсменами и другие тематические материалы.")
    Translatable content_genre_rest_sport_description();

    @TranslationStub("Новости и советы")
    Translatable content_genre_rest_shopping_name();

    @TranslationStub("Полезные и развлекательные статьи на тему шоппинга, подборки товаров.")
    Translatable content_genre_rest_shopping_description();
}
