package ru.yandex.direct.core.entity.conversionsource.model

import ru.yandex.direct.core.entity.conversionsourcetype.model.ConversionSourceTypeCode
import ru.yandex.direct.currency.Money
import ru.yandex.direct.dbutil.model.ClientId
import java.time.LocalDateTime

/**
 * Описание и настройки источника конверсий
 */
data class ConversionSource(
    // id  источник конверсий. Может быть null, при создании
    val id: ConversionSourceId?,

    val typeCode: ConversionSourceTypeCode,

    // id клиента, которому принадлежит источник конверсий
    val clientId: ClientId,

    val name: String,
    val settings: ConversionSourceSettings,
    val counterId: Long,
    val actions: List<ConversionAction>,
    val updatePeriodHours: Int,
    val destination: Destination,
    val processingInfo: ProcessingInfo,
)

sealed interface ConversionSourceSettings {
    data class Link(val url: String) : ConversionSourceSettings
    data class Metrika(val counterId: Long, val domain: String) : ConversionSourceSettings
    data class GoogleSheets(val url: String) : ConversionSourceSettings
    data class Ftp(
        val host: String,
        val port: Int,
        val tls: Boolean,
        val login: String,
        val encryptedPassword: String,
        val path: String,
    ) : ConversionSourceSettings

    data class SFtp(
        val host: String,
        val port: Int,
        val login: String,
        val encryptedPassword: String,
        val path: String,
    ) : ConversionSourceSettings
}

data class ConversionAction(
    val name: ConversionActionName,
    val goalId: Long?,
    val value: ConversionActionValue?,
)

sealed interface ConversionActionValue {
    data class Fixed(val cost: Money) : ConversionActionValue
    data class Dynamic(val costFrom: Money?, val costTo: Money?) : ConversionActionValue
}

sealed interface Destination {
    data class CrmApi(val counterId: Long, val accessUid: Long) : Destination
    object PostBack : Destination
}

data class ProcessingInfo(
    val processingStatus: ProcessingStatus,
    val lastStartTime: LocalDateTime? = null,
    val lastScheduledTime: LocalDateTime? = null,
)

enum class ProcessingStatus {
    NEW,
    PROCESSING,
    SUCCESS,
    ERROR,
}

typealias ConversionSourceId = Long
typealias ConversionActionName = String
