package ru.yandex.direct.core.entity.conversionsource.validation;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectId;

import static ru.yandex.direct.core.entity.conversionsource.validation.ConversionSourceDefects.Counter.COUNTER_IS_INACCESSIBLE;


public class ConversionSourceDefects {
    private ConversionSourceDefects() {
    }

    public enum Counter implements DefectId<Long> {
        COUNTER_IS_INACCESSIBLE,
    }

    public static Defect counterIsInaccessible(Long counterId) {
        return new Defect<>(COUNTER_IS_INACCESSIBLE, counterId);
    }
}
