package ru.yandex.direct.core.entity.creative.constants;

import java.util.Map;
import java.util.Optional;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.creative.service.add.validation.CreativeDefectTranslations;
import ru.yandex.direct.i18n.Translatable;

import static java.util.function.Function.identity;

/**
 * Причины запрета использования креатива
 */
public enum AdminRejectionReason {
    DEFAULT(CreativeDefectTranslations.INSTANCE.creativeDoesNotComply()),
    ;

    private final Translatable reason;

    private static final Map<String, AdminRejectionReason> reasonsByName = StreamEx
            .of(AdminRejectionReason.values())
            .mapToEntry(r -> r.name().toUpperCase(), identity())
            .toMap();

    AdminRejectionReason(Translatable reason) {
        this.reason = reason;
    }

    public Translatable getReason() {
        return reason;
    }

    @Nonnull
    public static AdminRejectionReason parse(@Nullable String reason) {
        return Optional.ofNullable(reason)
                .map(String::toUpperCase)
                .map(reasonsByName::get)
                .orElse(DEFAULT);
    }
}
