package ru.yandex.direct.core.entity.creative.model;


import ru.yandex.direct.canvas.client.model.video.ModerateInfo;
import ru.yandex.direct.core.entity.creative.repository.CreativeMappings;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;
import static ru.yandex.direct.utils.CommonUtils.nvl;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class CreativeConverter {
    public static Creative fromCanvasCreative(
            ru.yandex.direct.canvas.client.model.video.Creative creative) {
        boolean isAdaptive = nvl(creative.getIsAdaptive(), false);
        boolean isBrandLift = nvl(creative.getIsBrandLift(), false);
        boolean hasPackshot = nvl(creative.getHasPackshot(), false);
        return new Creative()
                .withId(creative.getCreativeId())
                .withName(creative.getCreativeName())
                .withType(fromCanvasCreativeType(creative.getCreativeType(), creative.getPresetId()))
                .withPreviewUrl(creative.getPreviewUrl())
                .withLivePreviewUrl(creative.getLivePreviewUrl())
                .withModerationInfo(fromCanvasModerateInfo(creative.getModerationInfo()))
                .withStockCreativeId(creative.getStockCreativeId())
                .withWidth(ifNotNull(creative.getWidth(), Integer::longValue))
                .withHeight(ifNotNull(creative.getHeight(), Integer::longValue))
                .withDuration(ifNotNull(creative.getDuration(), Integer::longValue))
                .withLayoutId(ifNotNull(creative.getPresetId(), Integer::longValue))
                .withIsAdaptive(isAdaptive)
                .withIsBrandLift(isBrandLift)
                .withHasPackshot(hasPackshot);
    }

    public static CreativeType fromCanvasCreativeType(
            ru.yandex.direct.canvas.client.model.video.Creative.CreativeType creativeType, Integer presetId) {
        if (creativeType == null) {
            return null;
        }
        switch (creativeType) {
            case PERFORMANCE:
                return CreativeType.PERFORMANCE;
            case CANVAS:
                return CreativeType.CANVAS;
            case VIDEO_ADDITION:
                return CreativeMappings.convertVideoType(ifNotNull(presetId, Integer::longValue));
            case HTML5_CREATIVE:
                return CreativeType.HTML5_CREATIVE;
            default:
                throw new IllegalStateException("No such value: " + creativeType);
        }
    }

    public static ModerationInfo fromCanvasModerateInfo(ModerateInfo moderateInfo) {
        return new ModerationInfo()
                .withAspects(mapList(moderateInfo.getAspects(), CreativeConverter::fromCanvasModerateInfoAspect))
                .withHtml(CreativeConverter.fromCanvasModerateInfoHtml(moderateInfo.getHtml()))
                .withImages(mapList(moderateInfo.getImages(), CreativeConverter::fromCanvasModerateInfoImage))
                .withSounds(mapList(moderateInfo.getSounds(), CreativeConverter::fromCanvasModerateInfoSound))
                .withTexts(mapList(moderateInfo.getTexts(), CreativeConverter::fromCanvasModerateInfoText))
                .withVideos(mapList(moderateInfo.getVideos(), CreativeConverter::fromCanvasModerateInfoVideo));
    }

    public static ModerationInfoAspect fromCanvasModerateInfoAspect(
            ru.yandex.direct.canvas.client.model.video.ModerationInfoAspect moderationInfoAspect) {
        return new ModerationInfoAspect()
                .withHeight(Long.valueOf(moderationInfoAspect.getHeight()))
                .withWidth(Long.valueOf(moderationInfoAspect.getWidth()));
    }

    public static ModerationInfoHtml fromCanvasModerateInfoHtml(
            ru.yandex.direct.canvas.client.model.video.ModerationInfoHtml moderationInfoHtml) {
        return new ModerationInfoHtml().withUrl(moderationInfoHtml.getUrl());
    }

    public static ModerationInfoImage fromCanvasModerateInfoImage(
            ru.yandex.direct.canvas.client.model.video.ModerationInfoImage moderationInfoImage) {
        return new ModerationInfoImage()
                .withUrl(moderationInfoImage.getUrl())
                .withAlt(moderationInfoImage.getAlt());
    }

    public static ModerationInfoSound fromCanvasModerateInfoSound(
            ru.yandex.direct.canvas.client.model.video.ModerationInfoSound moderationInfoSound) {
        return new ModerationInfoSound()
                .withUrl(moderationInfoSound.getUrl())
                .withStockId(moderationInfoSound.getStockId());
    }

    public static ModerationInfoText fromCanvasModerateInfoText(
            ru.yandex.direct.canvas.client.model.video.ModerationInfoText moderationInfoText) {
        return new ModerationInfoText()
                .withColor(moderationInfoText.getColor())
                .withText(moderationInfoText.getText())
                .withType(moderationInfoText.getType());
    }

    public static ModerationInfoVideo fromCanvasModerateInfoVideo(
            ru.yandex.direct.canvas.client.model.video.ModerationInfoVideo moderationInfoVideo) {
        return new ModerationInfoVideo()
                .withStockId(moderationInfoVideo.getStockId())
                .withUrl(moderationInfoVideo.getUrl());
    }
}
