package ru.yandex.direct.core.entity.creative.repository;

import java.util.List;
import java.util.Set;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;

import ru.yandex.direct.core.entity.creative.model.CreativeType;

import static ru.yandex.direct.core.entity.creative.model.CreativeType.VIDEO_ADDITION_CREATIVE;

public class CreativeConstants {
    private CreativeConstants() {
        // no instantiation
    }

    public static final int GET_USED_CREATIVES_LIMIT = 5_000;
    public static final RangeSet<Long> NON_SKIPPABLE_CPM_VIDEO_LAYOUT_ID =
            TreeRangeSet.create(List.of(Range.closed(7L, 8L), Range.closed(18L, 19L)));

    public static final Set<CreativeType> VIDEO_TYPES = ImmutableSet
            .of(VIDEO_ADDITION_CREATIVE, CreativeType.CPC_VIDEO_CREATIVE, CreativeType.CPM_VIDEO_CREATIVE,
                    CreativeType.CPM_OUTDOOR_CREATIVE, CreativeType.CPM_INDOOR_CREATIVE);

    public static final Range<Long> TEXT_VIDEO_ADDITION_LAYOUT_IDS = Range.closed(1L, 5L);
    public static final Range<Long> TEXT_VIDEO_ADDITION_TALL_LAYOUT_IDS = Range.closed(21L, 28L);
    public static final Range<Long> MOBILE_CONTENT_VIDEO_ADDITION_LAYOUT_IDS = Range.closed(11L, 17L);

    public static final RangeSet<Long> CPM_VIDEO_ADDITION_LAYOUT_IDS = TreeRangeSet.create(
            Iterables.concat(List.of(Range.closed(6L, 10L), Range.singleton(80L),
                            Range.closed(401L, 450L)),
                    NON_SKIPPABLE_CPM_VIDEO_LAYOUT_ID.asRanges()));

    public static final Range<Long> CPC_VIDEO_LAYOUT_IDS = Range.closed(41L, 55L);
    public static final Range<Long> MOBILE_CPC_VIDEO_LAYOUT_IDS = Range.closed(61L, 67L);

    public static final Range<Long> CPM_OUTDOOR_VIDEO_LAYOUT_IDS = Range.closed(101L, 150L);

    public static final Range<Long> CPM_INDOOR_VIDEO_LAYOUT_IDS = Range.closed(201L, 250L);

    public static final Range<Long> CPM_AUDIO_LAYOUT_IDS = Range.closed(301L, 350L);

    public static final Range<Long> CPM_OVERLAY_LAYOUT_IDS = Range.closed(351L, 400L);

}
