package ru.yandex.direct.core.entity.creative.repository;

import ru.yandex.direct.core.entity.creative.model.CreativeType;

public class CreativeInfo {
    private final CreativeType creativeType;
    private final boolean isExpandedCreative;
    private final Long layoutId;

    public CreativeInfo(CreativeType creativeType, boolean isExpandedCreative, Long layoutId) {
        this.creativeType = creativeType;
        this.isExpandedCreative = isExpandedCreative;
        this.layoutId = layoutId;
    }

    public CreativeInfo(CreativeType creativeType, boolean isExpandedCreative) {
        this.creativeType = creativeType;
        this.isExpandedCreative = isExpandedCreative;
        this.layoutId = null;
    }

    public CreativeType getCreativeType() {
        return creativeType;
    }

    public boolean isExpandedCreative() {
        return isExpandedCreative;
    }

    public Long getLayoutId() {
        return layoutId;
    }
}
