package ru.yandex.direct.core.entity.creative.service;

import javax.annotation.Nullable;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.creative.model.Creative;
import ru.yandex.direct.core.entity.creative.model.ModerationInfoText;

public class CreativeUtils {

    public static final String MODERATION_PROPERTY_TITLE = "title";
    public static final String MODERATION_PROPERTY_BODY = "body";

    public static String extractModerationInfoPropertyFromCreative(@Nullable Creative creative, String property) {
        if (creative == null
                || creative.getModerationInfo() == null
                || creative.getModerationInfo().getTexts() == null) {
            return null;
        }

        return StreamEx.of(creative.getModerationInfo().getTexts())
                .findFirst(mti -> mti.getType().equals(property))
                .map(ModerationInfoText::getText)
                .orElse(null);
    }
}
