package ru.yandex.direct.core.entity.creative.service.add.validation;

import java.util.Map;

import ru.yandex.direct.core.entity.creative.model.Creative;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;
import static ru.yandex.direct.validation.constraint.StringConstraints.maxStringLength;
import static ru.yandex.direct.validation.defect.CommonDefects.invalidValue;


public final class CreativeConstraints {
    private CreativeConstraints() {
    }

    static Constraint<Long, Defect> notInCreativeToClient(Long clientId, Map<Long, Long> creativeToClient) {
        return fromPredicate(
                cr -> creativeToClientContains(cr, clientId, creativeToClient),
                CreativeDefects.creativeNotBelongToClient(clientId));
    }

    static Constraint<Creative, Defect> sameCreativeType(Map<Long, Creative> existingCreatives) {
        return fromPredicate(cr -> cr.getType().equals(existingCreatives.get(cr.getId()).getType()),
                invalidValue());
    }

    static Constraint<String, Defect> maxPreviewUrl() {
        return maxStringLength(Constants.MAX_PREVIEW_URL_LENGTH);
    }

    static Constraint<String, Defect> maxName() {
        return maxStringLength(Constants.MAX_CREATIVE_NAME_LENGTH);
    }

    private static boolean creativeToClientContains(Long creativeId, Long clientId, Map<Long, Long> creativeToClient) {
        if (!creativeToClient.containsKey(creativeId)) {
            return true;
        }
        Long creativeClientId = creativeToClient.get(creativeId);
        return creativeClientId == null ||
                creativeClientId.equals(clientId);
    }
}
