package ru.yandex.direct.core.entity.creative.service.add.validation;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;

public interface CreativeDefectTranslations extends TranslationBundle {

    CreativeDefectTranslations INSTANCE = I18NBundle.implement(CreativeDefectTranslations.class);

    @MessageFormatStub("Идентификатор уже присвоен другому креативу")
    Translatable anotherCreativeId();

    @MessageFormatStub("Такой креатив уже существует у клиента")
    Translatable creativeAlreadyExists();

    @MessageFormatStub("Креатив не принадлежит клиенту {0}")
    Translatable creativeNotBelongToClient(Translatable clientId);

    @MessageFormatStub("Креатив уже существует")
    Translatable duplicateCreativeId();

    @MessageFormatStub("У клиента {0} не может быть еще одного такого же видео-дополнения")
    Translatable duplicateClientVideo(Long clientId);

    @MessageFormatStub("Креатив не отвечает техническим требованиям")
    Translatable creativeDoesNotComply();
}
