package ru.yandex.direct.core.entity.creative.service.add.validation;

import ru.yandex.direct.core.entity.creative.constants.AdminRejectionReason;
import ru.yandex.direct.validation.result.Defect;

public class CreativeDefects {
    public static Defect creativeNotBelongToClient(Long clientId) {
        return new Defect<>(CreativeDefectIds.ClientIds.CREATIVE_NOT_BELONG_TO_CLIENT, clientId);
    }

    public static Defect creativeIsAdminRejected(AdminRejectionReason reason) {
        return new Defect<>(CreativeDefectIds.AdminReject.CREATIVE_IS_ADMIN_REJECTED, reason);
    }

    public static Defect uploadVideoFailed() {
        return new Defect<>(CreativeDefectIds.Gen.UPLOAD_VIDEO_FAILED);
    }

    public static Defect createAdditionFromVideoFailed() {
        return new Defect<>(CreativeDefectIds.Gen.CREATE_ADDITION_FROM_VIDEO_FAILED);
    }
}
