package ru.yandex.direct.core.entity.crypta.repository

import ru.yandex.direct.core.entity.crypta.model.CaCryptaSegment
import ru.yandex.direct.core.entity.crypta.model.CaCryptaSegmentExport
import ru.yandex.direct.core.entity.crypta.model.CaCryptaSegmentName
import ru.yandex.direct.core.entity.crypta.model.CaCryptaSegmentType
import ru.yandex.direct.core.entity.crypta.ytmodels.generated.YtCryptaSegments
import ru.yandex.direct.core.entity.crypta.ytmodels.generated.YtCryptaSegmentsRow
import ru.yandex.inside.yt.kosher.ytree.YTreeNode
import java.lang.IllegalStateException

object CryptaSegmentsYtConverter {
    private const val SEGMENT_ID_FIELD = "segment_id"
    private const val KEYWORD_ID_FIELD = "keyword_id"
    private const val NAME_FIELD = "name"
    private const val DESCRIPTION_FIELD = "description"
    private const val LANGUAGE_FIELD = "language"

    fun convertFromYt(row: YtCryptaSegmentsRow): CaCryptaSegment = CaCryptaSegment()
        .withExports(
            extractListOfValues(row, YtCryptaSegments.EXPORTS.name) { convertToSegmentExport(it.asMap()) }
        )
        .withNames(
            extractListOfValues(row, YtCryptaSegments.TANKER_NAMES.name) { convertToSegmentName(it.asMap()) }
        )
        .withCampaignTypes(
            extractListOfValues(row, YtCryptaSegments.CAMPAIGN_TYPES.name, this::convertToString)
        )
        .withTankerNameKey(row.tankerNameKey)
        .withTankerDescriptionKey(row.tankerDescriptionKey)
        .withTankerSegmentTypeKey(row.tankerSegmentTypeKey)

    private fun <T> extractListOfValues(row: YtCryptaSegmentsRow, fieldName: String, mapper: (YTreeNode) -> T) =
        row.data[fieldName]
            .map { node -> node.listNode().map { mapper(it) } }
            .orElseThrow { IllegalStateException("Field '${fieldName}' doesn't exist") }

    private fun convertToSegmentExport(values: Map<String, YTreeNode>) = CaCryptaSegmentExport()
        .withSegmentId(values[SEGMENT_ID_FIELD]?.intValue())
        .withKeywordId(values[KEYWORD_ID_FIELD]?.intValue())

    private fun convertToSegmentName(value: Map<String, YTreeNode>) = CaCryptaSegmentName()
        .withName(value[NAME_FIELD]?.stringValue())
        .withDescription(value[DESCRIPTION_FIELD]?.stringValue())
        .withLanguage(value[LANGUAGE_FIELD]?.stringValue())

    private fun convertToString(value: YTreeNode) = value.stringValue()

}
