package ru.yandex.direct.core.entity.currency.model;

import java.util.Map;
import java.util.Objects;

import javax.annotation.Nonnull;

/**
 * Максимальное возможное количество сочетаний стран-валют для агентств и обычных клиентов (См. Currencies.pm)
 */
public class AnyCountryCurrencyCount {
    /**
     * Для агентств
     */
    private final int agencyCurrencyCount;
    /**
     * Для обычных клиентов
     */
    private final int clientCurrencyCount;

    public AnyCountryCurrencyCount(int agencyCurrencyCount, int clientCurrencyCount) {
        this.agencyCurrencyCount = agencyCurrencyCount;
        this.clientCurrencyCount = clientCurrencyCount;
    }

    /**
     * Сконструировать максимальное возможное количество сочетаний стран-валют для агентств и обычных клиентов
     *
     * @param map Отображение true => данные по агенствам, false => данные по обычным клиентам
     */
    @Nonnull
    public static AnyCountryCurrencyCount fromMap(Map<Boolean, Integer> map) {
        Objects.requireNonNull(map, "map");
        return new AnyCountryCurrencyCount(
                // Агенства
                map.getOrDefault(Boolean.TRUE, 0),
                // Обычные клиенты
                map.getOrDefault(Boolean.FALSE, 0));
    }

    public int getAgencyCurrencyCount() {
        return agencyCurrencyCount;
    }

    public int getClientCurrencyCount() {
        return clientCurrencyCount;
    }
}
