package ru.yandex.direct.core.entity.currency.model.cpmyndxfrontpage;

import java.util.List;
import java.util.Map;
import java.util.Set;

import one.util.streamex.StreamEx;

import ru.yandex.direct.regions.GeoTree;

/**
 * Функции-утилиты для валидации связи гео и ставок для групп на главной
 */
public class FrontpageGeoUtils {

    /**
     * Получение списка регионов, по которым можем выдать предупреждение, что показов в них не будет
     * Подробности в GeoTree.getIncludedRegions
     *
     * @param geoTree                 геодерево
     * @param adGroupGeo              геотаргетинг группы
     * @param regionsWithRestrictions список регионов, по которым выставлены минимальные ограничения на ставку
     * @return Список регионов, по которым можем выдать предупреждение, что показов в них не будет
     */
    public static Set<Long> getAdGroupRegionsInclusiveRestrictedRegions(GeoTree geoTree, List<Long> adGroupGeo,
                                                                        Set<Long> regionsWithRestrictions) {
        return geoTree.getIncludedRegions(regionsWithRestrictions, adGroupGeo);
    }

    /**
     * Получение регионов, содержащихся в списке регионов, по которым выставлены минимальные ограничения
     * на ставку, которые при этом содержат внутри себя плюс-регион из геотаргетинга группы
     *
     * @param geoTree                 геодерево
     * @param adGroupGeo              геотаргетинг группы
     * @param regionsWithRestrictions список регионов, по которым выставлены минимальные ограничения на ставку
     * @return Мапа регион геотаргетинга->регион с ограничениями
     */
    public static Map<Long, Long> getAdGroupRegionsIncludedIntoRestrictedRegions(GeoTree geoTree, List<Long> adGroupGeo,
                                                                                 Set<Long> regionsWithRestrictions) {
        return StreamEx.of(adGroupGeo)
                .filter(id -> id >= 0L)
                .distinct()
                .mapToEntry(id -> geoTree.upRegionTo(id, regionsWithRestrictions))
                .filterValues(regionsWithRestrictions::contains)
                .toMap();
    }
}
