package ru.yandex.direct.core.entity.currency.repository;

import java.time.LocalDateTime;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.Tables.FORCE_CURRENCY_CONVERT;

/**
 * Репозиторий для работы с таблицей {@link ru.yandex.direct.dbschema.ppc.Tables#FORCE_CURRENCY_CONVERT}.
 * Таблица хранит список клиентов, подтвердивших оферту с пунктом, позволяющим их принудительный перевод в валюту.
 * Заполняется из нотификации от Баланса NotifyClient2 и скриптом ppcForceCurrencyConvertNotify.pl
 */
@Repository
@ParametersAreNonnullByDefault
public class ForceCurrencyConvertRepository {
    private final DslContextProvider databaseWrapperProvider;

    @Autowired
    public ForceCurrencyConvertRepository(DslContextProvider databaseWrapperProvider) {
        this.databaseWrapperProvider = databaseWrapperProvider;
    }

    /**
     * Отмечает клиента как доступного для принудительного перевода в валюту.
     *
     * @param shard
     * @param clientId
     */
    public void setClientCanBeForciblyConvertedToCurrency(int shard, ClientId clientId) {
        databaseWrapperProvider.ppc(shard)
                .insertInto(FORCE_CURRENCY_CONVERT)
                .set(FORCE_CURRENCY_CONVERT.CLIENT_ID, clientId.asLong())
                .set(FORCE_CURRENCY_CONVERT.ACCEPTED_AT, LocalDateTime.now())
                .onDuplicateKeyIgnore()
                .execute();
    }

}
