package ru.yandex.direct.core.entity.currency.service;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.currency.CurrencyCode;

@Component
@ParametersAreNonnullByDefault
public class CurrencyConverterFactory {
    private final CurrencyRateService currencyRateService;

    public CurrencyConverterFactory(CurrencyRateService currencyRateService) {
        this.currencyRateService = currencyRateService;
    }

    public CurrencyConverter createConverter(CurrencyCode currencyFrom,
                                             CurrencyCode currencyTo) {
        return new CurrencyConverter(currencyRateService, currencyFrom, currencyTo);
    }
}
