package ru.yandex.direct.core.entity.currency.service.validation;

import java.util.Objects;

import ru.yandex.direct.currency.CurrencyCode;

public class CurrencyDefectParams {
    private CurrencyCode currencyCode;

    public CurrencyCode getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
    }

    public CurrencyDefectParams withCurrencyCode(CurrencyCode currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    @Override
    public String toString() {
        return "CurrencyDefectParams{" +
                "currencyCode=" + currencyCode +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CurrencyDefectParams that = (CurrencyDefectParams) o;
        return currencyCode == that.currencyCode;
    }

    @Override
    public int hashCode() {
        return Objects.hash(currencyCode);
    }
}
