package ru.yandex.direct.core.entity.dbqueue;

import ru.yandex.direct.core.copyentity.model.CampaignCopyJobParams;
import ru.yandex.direct.core.copyentity.model.CampaignCopyJobResult;
import ru.yandex.direct.core.entity.agencyofflinereport.container.AgencyOfflineReportBuilderJobResult;
import ru.yandex.direct.core.entity.agencyofflinereport.container.AgencyOfflineReportJobParams;
import ru.yandex.direct.core.entity.balanceaggrmigration.container.BalanceAggregateMigrationParams;
import ru.yandex.direct.core.entity.balanceaggrmigration.container.BalanceAggregateMigrationResult;
import ru.yandex.direct.core.entity.brandlift.model.BrandLiftRecalcJobParams;
import ru.yandex.direct.core.entity.brandlift.model.BrandLiftRecalcJobResult;
import ru.yandex.direct.core.entity.domain.model.BannerUpdateAggeregatorDomainParams;
import ru.yandex.direct.core.entity.domain.model.BannerUpdateAggeregatorDomainResult;
import ru.yandex.direct.core.entity.offlinereport.model.OfflineReportJobParams;
import ru.yandex.direct.core.entity.offlinereport.model.OfflineReportJobResult;
import ru.yandex.direct.core.entity.payment.model.TurnOnAutopayJobParams;
import ru.yandex.direct.core.entity.payment.model.TurnOnAutopayJobResult;
import ru.yandex.direct.core.entity.postviewofflinereport.model.PostviewOfflineReportJobParams;
import ru.yandex.direct.core.entity.postviewofflinereport.model.PostviewOfflineReportJobResult;
import ru.yandex.direct.core.entity.takeout.model.TakeoutJobParams;
import ru.yandex.direct.core.entity.takeout.model.TakeoutJobResult;
import ru.yandex.direct.core.entity.turbolanding.container.UpdateCounterGrantsParams;
import ru.yandex.direct.core.entity.turbolanding.container.UpdateCounterGrantsResult;
import ru.yandex.direct.core.entity.uac.model.CheckAudienceSegmentJobParams;
import ru.yandex.direct.core.entity.uac.model.CheckAudienceSegmentJobResult;
import ru.yandex.direct.core.entity.uac.model.UpdateAdsJobParams;
import ru.yandex.direct.core.entity.uac.model.UpdateAdsJobResult;
import ru.yandex.direct.core.entity.uac.model.UpdateVideoContentJobParams;
import ru.yandex.direct.core.entity.uac.model.UpdateVideoContentJobResult;
import ru.yandex.direct.dbqueue.DbQueueJobType;

/**
 * Здесь надо объявлять все константы типа {@link ru.yandex.direct.dbqueue.DbQueueJobType}
 */
public class DbQueueJobTypes {
    public static final DbQueueJobType<AgencyOfflineReportJobParams, AgencyOfflineReportBuilderJobResult>
            AGENCY_DASHBOARD_REPORT =
            new DbQueueJobType<>("agency_dashboard_report", AgencyOfflineReportJobParams.class,
                    AgencyOfflineReportBuilderJobResult.class);

    public static final DbQueueJobType<BalanceAggregateMigrationParams, BalanceAggregateMigrationResult>
            BALANCE_AGGREGATE_MIGRATION =
            new DbQueueJobType<>("convert_campaigns_aggr_schema", BalanceAggregateMigrationParams.class,
                    BalanceAggregateMigrationResult.class);

    public static final DbQueueJobType<UpdateCounterGrantsParams, UpdateCounterGrantsResult>
            UPDATE_COUNTER_GRANTS_JOB =
            new DbQueueJobType<>("update_counter_grants_job", UpdateCounterGrantsParams.class,
                    UpdateCounterGrantsResult.class);

    public static final DbQueueJobType<TakeoutJobParams, TakeoutJobResult>
            TAKEOUT_REQUEST =
            new DbQueueJobType<>("takeout_request", TakeoutJobParams.class,
                    TakeoutJobResult.class);

    public static final DbQueueJobType<OfflineReportJobParams, OfflineReportJobResult>
            OFFLINE_REPORT =
            new DbQueueJobType<>("offline_report", OfflineReportJobParams.class, OfflineReportJobResult.class);

    public static final DbQueueJobType<BannerUpdateAggeregatorDomainParams, BannerUpdateAggeregatorDomainResult>
            UPDATE_AGGREGATOR_DOMAINS =
            new DbQueueJobType<>("update_aggregator_domains", BannerUpdateAggeregatorDomainParams.class,
                    BannerUpdateAggeregatorDomainResult.class);

    public static final DbQueueJobType<TurnOnAutopayJobParams, TurnOnAutopayJobResult> TURN_ON_AUTOPAY =
            new DbQueueJobType<>("turn_on_autopay", TurnOnAutopayJobParams.class, TurnOnAutopayJobResult.class);

    public static final DbQueueJobType<CampaignCopyJobParams, CampaignCopyJobResult> CAMPAIGNS_COPY =
            new DbQueueJobType<>("campaigns_copy", CampaignCopyJobParams.class, CampaignCopyJobResult.class);

    public static final DbQueueJobType<BrandLiftRecalcJobParams, BrandLiftRecalcJobResult> RECALC_BRAND_LIFT_CAMPAIGNS =
            new DbQueueJobType<>("recalc_brand_lift_campaigns", BrandLiftRecalcJobParams.class, BrandLiftRecalcJobResult.class);

    public static final DbQueueJobType<UpdateAdsJobParams, UpdateAdsJobResult> UAC_UPDATE_ADS =
            new DbQueueJobType<>("uac_update_ads", UpdateAdsJobParams.class, UpdateAdsJobResult.class);

    public static final DbQueueJobType<UpdateVideoContentJobParams, UpdateVideoContentJobResult> UAC_UPDATE_VIDEO_CONTENT =
            new DbQueueJobType<>("uac_update_video_content", UpdateVideoContentJobParams.class, UpdateVideoContentJobResult.class);

    public static final DbQueueJobType<CheckAudienceSegmentJobParams, CheckAudienceSegmentJobResult> UAC_CHECK_AUDITION_SEGMENTS =
            new DbQueueJobType<>("uac_check_audition_segments", CheckAudienceSegmentJobParams.class, CheckAudienceSegmentJobResult.class);

    public static final DbQueueJobType<PostviewOfflineReportJobParams, PostviewOfflineReportJobResult> POSTVIEW_OFFLINE_REPORT =
            new DbQueueJobType<>("postview_offline_report", PostviewOfflineReportJobParams.class, PostviewOfflineReportJobResult.class);

    private DbQueueJobTypes() {
    }
}
