package ru.yandex.direct.core.entity.deal.model;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Почему этот договор в Балансе не подходит для того, чтобы на его основании разрешить
 * клиенту пользоваться частными сделками.
 */
@ParametersAreNonnullByDefault
public enum BalanceContractProblem {
    /**
     * ещё не начал действовать
     */
    NOT_STARTED_YET,

    /**
     * уже закончил действовать
     */
    EXPIRED,

    /**
     * не подписан (даже по факсу)
     */
    NOT_SIGNED,

    /**
     * расторгнут
     */
    CANCELLED,

    /**
     * приостановлен
     */
    SUSPENDED,

    /**
     * не относится к сервису "Директ" в Балансе
     */
    NOT_RELATED_TO_DIRECT
}
