package ru.yandex.direct.core.entity.deal.model;

import java.math.BigDecimal;
import java.time.LocalDate;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Информация о договоре и дополнительном соглашении в Балансе, нужная для формирования уведомления
 * о заключённой сделке.
 */
@ParametersAreNonnullByDefault
public class BalancePrivateDealInfo {
    /**
     * видимый клиенту номер договора, например, "285245/18"
     */
    private final String externalContractId;

    /**
     * дата заключения договора
     */
    private final LocalDate contractStartDate;

    /**
     * видимый клиенту номер дополнительного соглашения, например, "01"
     */
    private final String externalCollateralId;

    /**
     * процент специальной премии - 2, например, 15
     */
    private final BigDecimal dealBasePercent;

    public BalancePrivateDealInfo(String externalContractId, LocalDate contractStartDate,
                                  String externalCollateralId, BigDecimal dealBasePercent) {
        this.externalContractId = externalContractId;
        this.contractStartDate = contractStartDate;
        this.externalCollateralId = externalCollateralId;
        this.dealBasePercent = dealBasePercent;
    }

    public String getExternalContractId() {
        return externalContractId;
    }

    public LocalDate getContractStartDate() {
        return contractStartDate;
    }

    public String getExternalCollateralId() {
        return externalCollateralId;
    }

    public BigDecimal getDealBasePercent() {
        return dealBasePercent;
    }
}
