package ru.yandex.direct.core.entity.deal.model;

import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonGetter;
import one.util.streamex.EntryStream;

import ru.yandex.direct.balance.client.model.response.PartnerContractCollateralInfo;
import ru.yandex.direct.balance.client.model.response.PartnerContractInfo;

/**
 * Информация о том, как происходил поиск подходящего договора и доп. соглашения
 * в Балансе.
 */
@ParametersAreNonnullByDefault
public class BalancePrivateDealSearchResult {
    /**
     * что вернул Баланс
     */
    @Nullable
    private List<PartnerContractInfo> balanceResponse;

    /**
     * проблемы с контрактами внутри balanceResponse; проблемы каждого контракта
     * в этом списке с тем же индексом, что и индекс соответствующего контракта
     * в balanceResponse
     */
    @Nullable
    private List<Set<BalanceContractProblem>> contractProblems;

    /**
     * в скольких из контрактов нет никаких проблем; для успешного поиска
     * должен остаться ровно один контракт
     */
    @Nullable
    private Integer suitableContractCount;

    /**
     * часть ответа Баланса, которая относится к (единственному) подходящему контракту;
     * если подходящий контракт не один, здесь и в полях про дальнейшие шаги null
     */
    @Nullable
    private PartnerContractInfo relevantContractInfo;

    /**
     * правильная ли валюта у (единственного) подходящего контракта
     */
    @Nullable
    private Boolean relevantContractHasCorrectCurrency;

    /**
     * проблемы с доп. соглашениями внутри relevantContractInfo; проблемы каждого доп. соглашения
     * в этом списке с тем же индексом, что и индекс соответствующего доп. соглашения
     * в relevantContractInfo.getCollaterals()
     */
    @Nullable
    private List<Set<BalanceCollateralProblem>> collateralProblems;

    /**
     * в скольких из доп. соглашений подходящего контракта нет проблем; для успешного поиска
     * должно остаться ровно одно доп. соглашение
     */
    @Nullable
    private Integer suitableCollateralCount;

    /**
     * из какого доп. соглашения мы берём информацию про его номер и процент премии
     */
    @Nullable
    private PartnerContractCollateralInfo relevantCollateral;

    /**
     * всё нашли успешно?
     */
    private boolean foundContractAndCollateral = false;

    /**
     * информация, нужная для формирования уведомления о частной сделке
     */
    @Nullable
    private BalancePrivateDealInfo balancePrivateDealInfo;

    @Nullable
    public List<PartnerContractInfo> getBalanceResponse() {
        return balanceResponse;
    }

    public void setBalanceResponse(@Nullable List<PartnerContractInfo> balanceResponse) {
        this.balanceResponse = balanceResponse;
    }

    @Nullable
    public List<Set<BalanceContractProblem>> getContractProblems() {
        return contractProblems;
    }

    /**
     * "нечестный" геттер, который возвращает не список проблем, а Map&lt;String, Set&gt;,
     * в котором ключи — это externalContractId договоро, потому что так проще читать результат
     */
    @JsonGetter("contractProblems")
    public Map<String, Set<BalanceContractProblem>> getContractProblemsForJson() {
        if (balanceResponse == null || contractProblems == null) {
            return null;
        }

        return EntryStream.of(contractProblems)
                .mapKeys(i -> "[" + i + "] " + balanceResponse.get(i).getContract().getExternalContractId())
                .toMap();
    }

    public void setContractProblems(@Nullable List<Set<BalanceContractProblem>> contractProblems) {
        this.contractProblems = contractProblems;
    }

    @Nullable
    public Integer getSuitableContractCount() {
        return suitableContractCount;
    }

    public void setSuitableContractCount(@Nullable Integer suitableContractCount) {
        this.suitableContractCount = suitableContractCount;
    }

    @Nullable
    public PartnerContractInfo getRelevantContractInfo() {
        return relevantContractInfo;
    }

    public void setRelevantContractInfo(@Nullable PartnerContractInfo relevantContractInfo) {
        this.relevantContractInfo = relevantContractInfo;
    }

    public void setRelevantContractHasCorrectCurrency(Boolean relevantContractHasCorrectCurrency) {
        this.relevantContractHasCorrectCurrency = relevantContractHasCorrectCurrency;
    }

    public Boolean getRelevantContractHasCorrectCurrency() {
        return relevantContractHasCorrectCurrency;
    }

    @Nullable
    public List<Set<BalanceCollateralProblem>> getCollateralProblems() {
        return collateralProblems;
    }

    /**
     * "нечестный" геттер, который возвращает не список проблем, а Map&lt;String, Set&gt;,
     * в котором ключи — это externalCollateralId доп. соглашений, потому что так проще читать результат
     */
    @JsonGetter("collateralProblems")
    public Map<String, Set<BalanceCollateralProblem>> getCollateralProblemsForJson() {
        if (relevantContractInfo == null || collateralProblems == null) {
            return null;
        }

        List<PartnerContractCollateralInfo> collaterals = relevantContractInfo.getCollaterals();
        return EntryStream.of(collateralProblems)
                .mapKeys(i -> "[" + i + "] " + collaterals.get(i).getExternalCollateralId())
                .toMap();
    }

    public void setCollateralProblems(
            @Nullable List<Set<BalanceCollateralProblem>> collateralProblems) {
        this.collateralProblems = collateralProblems;
    }

    @Nullable
    public PartnerContractCollateralInfo getRelevantCollateral() {
        return relevantCollateral;
    }

    public void setRelevantCollateral(
            @Nullable PartnerContractCollateralInfo relevantCollateral) {
        this.relevantCollateral = relevantCollateral;
    }

    public boolean foundContractAndCollateral() {
        return foundContractAndCollateral;
    }

    public void setFoundContractAndCollateral(boolean foundContractAndCollateral) {
        this.foundContractAndCollateral = foundContractAndCollateral;
    }

    @Nullable
    public BalancePrivateDealInfo getBalancePrivateDealInfo() {
        return balancePrivateDealInfo;
    }

    public void setBalancePrivateDealInfo(@Nullable BalancePrivateDealInfo balancePrivateDealInfo) {
        this.balancePrivateDealInfo = balancePrivateDealInfo;
    }

    public void setSuitableCollateralCount(Integer suitableCollateralCount) {
        this.suitableCollateralCount = suitableCollateralCount;
    }

    public Integer getSuitableCollateralCount() {
        return suitableCollateralCount;
    }

}
