package ru.yandex.direct.core.entity.deal.model;

import ru.yandex.direct.currency.Money;

import static ru.yandex.direct.core.entity.deal.service.DealService.AGENCY_TAX;

public class Deal extends DealBase {

    /**
     * Возвращается CPM с учётом комиссий.
     * <p>
     * https://st.yandex-team.ru/DIRECT-72093#1509112727000
     * К минимальной цене (что Adfox называет "cpm") мы прибавляем
     * комиссию "marginRatio" и
     * комиссию с агенства, которая настраивается у нас (15% по умолчанию).
     */
    public Money getAgencyMinPrice() {
        Money cpm = Money.valueOf(getCpm(), getCurrencyCode());
        if (getMarginRatio() != null) {
            cpm = cpm.add(getMarginRatio());
        }
        return cpm.add(AGENCY_TAX).roundToAuctionStepUp();
    }
}
