package ru.yandex.direct.core.entity.deal.repository;

import java.util.Arrays;
import java.util.List;

import javax.annotation.Nullable;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.direct.common.util.EncodingUtils;
import ru.yandex.direct.core.entity.deal.model.DealPlacement;

import static java.util.Collections.emptyList;
import static ru.yandex.direct.utils.JsonUtils.fromJson;

public class DealMappings {

    private static final ObjectMapper objectMapper = createObjectMapper();

    private DealMappings() {
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(MapperFeature.AUTO_DETECT_CREATORS,
                MapperFeature.AUTO_DETECT_FIELDS,
                MapperFeature.AUTO_DETECT_GETTERS,
                MapperFeature.AUTO_DETECT_IS_GETTERS);
        return mapper;
    }


    @Nullable
    public static String placementsToJson(@Nullable List<DealPlacement> placements) {
        try {
            return objectMapper.writeValueAsString(placements);
        } catch (JsonProcessingException e) {
            throw new IllegalArgumentException("can not serialize object to json", e);
        }
    }

    public static List<DealPlacement> placementsFromJson(@Nullable String jsonPlacements) {
        if (jsonPlacements == null) {
            return emptyList();
        }
        DealPlacement[] placements = fromJson(EncodingUtils.recoverUtf8Decode(jsonPlacements), DealPlacement[].class);
        if (placements == null) {
            return emptyList();
        }
        return Arrays.asList(placements);
    }
}
