package ru.yandex.direct.core.entity.deal.service;

import java.util.Calendar;

import ru.yandex.direct.core.entity.deal.model.Deal;

/**
 * Данные для формирования заголовка/текста письма с уведомлением о заключённой частной сделке
 */
class DealNotificationEmailParameters {
    private final Deal deal;                            // сделка
    private final String notificationId;                // видимый клиенту ID: 20180123-020355
    private final String contractId;                    // номер договора
    private final Calendar contractDate;                // дата заключения договора
    private final String contractAdditionalAgreementId; // номер доп. соглашения
    private final String pdfFileName;                   // имя подписанного PDF-файла
    private final byte[] signedPdfContent;              // содержимое подписанного PDF-файла
    private final String emailTo;                       // email, на который отправляется документ

    private DealNotificationEmailParameters(Deal deal, String notificationId, String contractId,
                                            Calendar contractDate, String contractAdditionalAgreementId, String pdfFileName, byte[] signedPdfContent,
                                            String emailTo) {
        this.deal = deal;
        this.notificationId = notificationId;
        this.contractId = contractId;
        this.contractDate = contractDate;
        this.contractAdditionalAgreementId = contractAdditionalAgreementId;
        this.pdfFileName = pdfFileName;
        this.signedPdfContent = signedPdfContent;
        this.emailTo = emailTo;
    }

    Deal getDeal() {
        return deal;
    }

    String getNotificationId() {
        return notificationId;
    }

    String getContractId() {
        return contractId;
    }

    Calendar getContractDate() {
        return contractDate;
    }

    String getContractAdditionalAgreementId() {
        return contractAdditionalAgreementId;
    }

    String getPdfFileName() {
        return pdfFileName;
    }

    byte[] getSignedPdfContent() {
        return signedPdfContent;
    }

    public String getEmailTo() {
        return emailTo;
    }

    static class Builder {
        private Deal deal;
        private String notificationId;
        private String contractId;
        private Calendar contractDate;
        private String contractAdditionalAgreementId;
        private String pdfFileName;
        private byte[] signedPdfContent;
        private String emailTo;

        Builder setDeal(Deal deal) {
            this.deal = deal;
            return this;
        }

        Builder setNotificationId(String notificationId) {
            this.notificationId = notificationId;
            return this;
        }

        Builder setContractId(String contractId) {
            this.contractId = contractId;
            return this;
        }

        Builder setContractDate(Calendar contractDate) {
            this.contractDate = contractDate;
            return this;
        }

        Builder setContractAdditionalAgreementId(String contractAdditionalAgreementId) {
            this.contractAdditionalAgreementId = contractAdditionalAgreementId;
            return this;
        }

        Builder setPdfFileName(String pdfFileName) {
            this.pdfFileName = pdfFileName;
            return this;
        }

        Builder setSignedPdfContent(byte[] signedPdfContent) {
            this.signedPdfContent = signedPdfContent;
            return this;
        }

        Builder setEmailTo(String emailTo) {
            this.emailTo = emailTo;
            return this;
        }

        DealNotificationEmailParameters build() {
            return new DealNotificationEmailParameters(deal, notificationId, contractId, contractDate,
                    contractAdditionalAgreementId, pdfFileName, signedPdfContent, emailTo);
        }
    }
}
