package ru.yandex.direct.core.entity.deal.service;

import java.util.Calendar;
import java.util.List;

/**
 * Данные для PDF-файла с уведомлением о заключённой частной сделке
 */
public class DealNotificationPdfParameters {
    private final String notificationId;             // номер уведомления: 20180123-020355
    private final String contractId;                 // номер договора
    private final Calendar contractDate;             // дата договора
    private final Long dealId;                       // ID сделки
    private final List<Long> pageIds;                // ID площадок
    private final String specialPremiumPercentage;   // процент специальной премии - 2
    private final String emailFrom;                  // email, с которого отправляется документ

    private DealNotificationPdfParameters(String notificationId, String contractId, Calendar contractDate,
                                          Long dealId, List<Long> pageIds, String specialPremiumPercentage, String emailFrom) {
        this.notificationId = notificationId;
        this.contractId = contractId;
        this.contractDate = contractDate;
        this.dealId = dealId;
        this.pageIds = pageIds;
        this.specialPremiumPercentage = specialPremiumPercentage;
        this.emailFrom = emailFrom;
    }

    @SuppressWarnings("unused") // методы getX в этом классе дёргает PropertyUtils.describe через reflection
    public String getNotificationId() {
        return notificationId;
    }

    @SuppressWarnings("unused")
    public String getContractId() {
        return contractId;
    }

    @SuppressWarnings("unused")
    public Calendar getContractDate() {
        return contractDate;
    }

    @SuppressWarnings("unused")
    public Long getDealId() {
        return dealId;
    }

    @SuppressWarnings("unused")
    public List<Long> getPageIds() {
        return pageIds;
    }

    @SuppressWarnings("unused")
    public String getSpecialPremiumPercentage() {
        return specialPremiumPercentage;
    }

    @SuppressWarnings("unused")
    public String getEmailFrom() {
        return emailFrom;
    }

    static class Builder {
        private String notificationId;
        private String contractId;
        private Calendar contractDate;
        private Long dealId;
        private List<Long> pageIds;
        private String specialPremiumPercentage;
        private String emailFrom;

        Builder setNotificationId(String notificationId) {
            this.notificationId = notificationId;
            return this;
        }

        Builder setContractId(String contractId) {
            this.contractId = contractId;
            return this;
        }

        Builder setContractDate(Calendar contractDate) {
            this.contractDate = contractDate;
            return this;
        }

        Builder setDealId(Long dealId) {
            this.dealId = dealId;
            return this;
        }

        Builder setPageIds(List<Long> pageIds) {
            this.pageIds = pageIds;
            return this;
        }

        Builder setSpecialPremiumPercentage(String specialPremiumPercentage) {
            this.specialPremiumPercentage = specialPremiumPercentage;
            return this;
        }

        Builder setEmailFrom(String emailFrom) {
            this.emailFrom = emailFrom;
            return this;
        }

        DealNotificationPdfParameters build() {
            return new DealNotificationPdfParameters(
                    notificationId, contractId, contractDate,
                    dealId, pageIds, specialPremiumPercentage, emailFrom);
        }
    }
}
