package ru.yandex.direct.core.entity.deal.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableMap;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.deal.model.StatusDirect;

import static java.util.Arrays.asList;
import static java.util.Collections.emptyList;
import static java.util.Collections.singletonList;
import static ru.yandex.direct.core.entity.deal.model.StatusDirect.ACTIVE;
import static ru.yandex.direct.core.entity.deal.model.StatusDirect.ARCHIVED;
import static ru.yandex.direct.core.entity.deal.model.StatusDirect.COMPLETED;
import static ru.yandex.direct.core.entity.deal.model.StatusDirect.RECEIVED;

@Service
@ParametersAreNonnullByDefault
public class DealTransitionsService {
    private static final ImmutableMap<StatusDirect, List<StatusDirect>> AVAILABLE_CLIENT_TRANSITIONS;
    private static final ImmutableMap<StatusDirect, List<StatusDirect>> AVAILABLE_ADFOX_TRANSPORT_TRANSITIONS;

    static {
        Map<StatusDirect, List<StatusDirect>> transitions = new HashMap<>();
        transitions.put(RECEIVED, asList(COMPLETED, ACTIVE));
        transitions.put(ACTIVE, singletonList(COMPLETED));
        transitions.put(COMPLETED, singletonList(ARCHIVED));
        transitions.put(ARCHIVED, emptyList());
        AVAILABLE_CLIENT_TRANSITIONS = ImmutableMap.copyOf(transitions);

        transitions = new HashMap<>();
        transitions.put(RECEIVED, singletonList(COMPLETED));
        transitions.put(ACTIVE, singletonList(COMPLETED));
        transitions.put(COMPLETED, emptyList());
        transitions.put(ARCHIVED, emptyList());
        AVAILABLE_ADFOX_TRANSPORT_TRANSITIONS = ImmutableMap.copyOf(transitions);
    }

    public List<StatusDirect> getAvailableStatuses(StatusDirect currentStatus) {
        return AVAILABLE_CLIENT_TRANSITIONS.get(currentStatus);
    }

    public List<StatusDirect> getAvailableStatusesForTransport(StatusDirect currentStatus) {
        return AVAILABLE_ADFOX_TRANSPORT_TRANSITIONS.get(currentStatus);
    }
}
