package ru.yandex.direct.core.entity.deal.service.validation;

import java.util.Set;

import ru.yandex.direct.core.entity.deal.model.DealSimple;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;
import static ru.yandex.direct.validation.defect.CommonDefects.objectNotFound;

class DealConstraints {

    /**
     * Проверка вхождения сделки в список существующих сделок по ID
     */
    static <T extends DealSimple> Constraint<T, Defect> dealExists(Set<Long> existingDealIds) {
        return fromPredicate(deal -> existingDealIds.contains(deal.getId()), objectNotFound());
    }

}
