package ru.yandex.direct.core.entity.deal.service.validation;

import ru.yandex.direct.core.entity.currency.service.validation.CurrencyDefectParams;
import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.direct.validation.result.Defect;

public class DealDefects {
    public static Defect<Void> transitionIsUnavailable() {
        return new Defect<>(DealDefectIds.TRANSITION_IS_UNAVAILABLE);
    }

    public static Defect<Void> dealIsNotActive() {
        return new Defect<>(DealDefectIds.DEAL_IS_NOT_ACTIVE);
    }

    public static Defect<CurrencyDefectParams> dealCurrencyShouldMatchClient(CurrencyCode clientCurrency) {
        return new Defect<>(DealDefectIds.Currency.DEAL_CURRENCY_SHOULD_MATCH_CLIENT,
                new CurrencyDefectParams().withCurrencyCode(clientCurrency));
    }

    public static Defect<CurrencyDefectParams> dealCurrencyShouldMatchCampaign(
            CurrencyCode campaignCurrency) {
        return new Defect<>(DealDefectIds.Currency.CAMPAIGN_AND_DEAL_CURRENCY_SHOULD_MATCH,
                new CurrencyDefectParams().withCurrencyCode(campaignCurrency));
    }

}
