package ru.yandex.direct.core.entity.dialogs;

import ru.yandex.direct.core.entity.campaign.model.Dialog;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dialogs.client.model.Skill;

public class DialogUtils {

    public static Dialog convertSkillToDialog(Skill skill, ClientId clientId) {
        return new Dialog()
                .withSkillId(skill.getSkillId())
                .withBotGuid(skill.getBotGuid())
                .withName(normalizeName(skill.getName()))
                .withIsActive(skillIsActive(skill))
                .withClientId(clientId.asLong());
    }

    public static Boolean skillIsActive(Skill skill) {
        // Что считаем активным - https://st.yandex-team.ru/DIRECT-89241#5c26369e5699db001d55f9a8
        // Сейчас Диалоги не отдают чаты с onAir == false, но когда начнут отдавать, мы должны менять статус
        return skill.getError() == null && skill.getSkillId() != null && skill.getBotGuid() != null && skill.getOnAir();
    }

    /**
     * В Диалогах в имени чата могут храниться 4х-байтовые символы, которые мы не можем записать в базу.
     * Заменяем их на �
     */
    public static String normalizeName(String name) {
        if (name == null) {
            return name;
        }
        return name.replaceAll("[^\\u0000-\\uFFFF]", "\uFFFD");
    }

}
