package ru.yandex.direct.core.entity.domain;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static ru.yandex.direct.validation.constraint.StringConstraints.PROTOCOL_PATTERN;

@ParametersAreNonnullByDefault
public class SocialNetworkAccountDomainUtils {
    private static final Logger logger = LoggerFactory.getLogger(SocialNetworkAccountDomainUtils.class);

    private static final Pattern INSTAGRAM_ACCOUNT_URL_PATTERN = Pattern.compile(
            PROTOCOL_PATTERN +
                    "([^.]*\\.)*" +
                    "(instagram\\.com|instagr\\.am)" +
                    "/([A-Za-z0-9_.]+).*"
    );

    @Nullable
    public static String extractInstagramUsername(@Nullable String url) {
        if (url == null || url.isBlank()) {
            return null;
        }
        Matcher matcher = INSTAGRAM_ACCOUNT_URL_PATTERN.matcher(url.toLowerCase());
        try {
            return matcher.matches() ? matcher.group(3) : null;
        } catch (RuntimeException e) {
            logger.warn("Failed to extract instagram account username from " + url);
            return null;
        }
    }
}
