package ru.yandex.direct.core.entity.domain;

import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SubDomainParserForOkRu implements SubDomainParser {

    public static final String RESERVED_WORD = "/dk";
    private static final Pattern PROFILE_PATTERN = Pattern.compile("^/(profile)/(\\d+)");
    private static final Pattern GROUP_PATTERN = Pattern.compile("^/(group)/?(\\d+)");
    private static final Pattern PATH_PATTERN = Pattern.compile("^/([^/]+)");

    public String apply(URL url) {
        if (url.getPath() == null || url.getPath().startsWith(RESERVED_WORD)) {
            return null;
        }
        Matcher profileMatcher = PROFILE_PATTERN.matcher(url.getPath());
        Matcher groupMatcher = GROUP_PATTERN.matcher(url.getPath());
        Matcher pathMatcher = PATH_PATTERN.matcher(url.getPath());
        String subDomain = null;

        if (profileMatcher.find()) {
            subDomain = profileMatcher.group(1) + "-" + profileMatcher.group(2);
        } else if (groupMatcher.find()) {
            subDomain = groupMatcher.group(1) + "-" + groupMatcher.group(2);
        } else if (pathMatcher.find()) {
            subDomain = pathMatcher.group(1);
        }
        return subDomain;
    }
}
