package ru.yandex.direct.core.entity.domain;

import java.net.URL;
import java.util.Map;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import static ru.yandex.direct.core.entity.domain.DomainUtils.getQueryMap;

@ParametersAreNonnullByDefault
public class SubDomainParserForPokupki implements SubDomainParser {

    public static final String SUPPLIER_ID = "supplierid";

    @Nullable
    public String apply(URL url) {
        if (url.getQuery() != null) {
            Map<String, String> queryMap = getQueryMap(url.getQuery());
            return queryMap.get(SUPPLIER_ID);
        }
        return null;
    }
}
