package ru.yandex.direct.core.entity.domain;

import java.net.URL;
import java.util.Map;

import org.jetbrains.annotations.Nullable;

import static ru.yandex.direct.core.entity.domain.DomainUtils.getQueryMap;

public class SubDomainParserForProfiRu implements SubDomainParser {

    public static final String PROFILE_ID = "profileid";

    @Nullable
    @Override
    public String apply(URL url) {
        if (url.getQuery() != null) {
            Map<String, String> queryMap = getQueryMap(url.getQuery());
            return queryMap.get(PROFILE_ID);
        }
        return null;
    }
}
