package ru.yandex.direct.core.entity.domain;

import java.net.URL;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SubDomainParserForYandexCollections implements SubDomainParser {

    public static final String COLLECTIONS_USER = "/collections/user/";

    @Nullable
    public String apply(URL url) {
        if (url.getPath() != null && url.getPath().startsWith(COLLECTIONS_USER)) {
            return url.getPath().split("/", 5)[3];
        }
        return null;
    }
}
