package ru.yandex.direct.core.entity.domain;

import java.net.URL;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.annotation.Nullable;

import static ru.yandex.direct.core.entity.domain.DomainUtils.getQueryMap;

public class SubDomainParserForYandexMaps implements SubDomainParser {
    private static final Pattern PATH_PATTERN = Pattern.compile("^/(maps/|web-maps/)*org/(\\d+)+$");
    public static final String ORG_PAGE_ID = "orgpage[id]";

    @Nullable
    public String apply(URL url) {
        Matcher matcher = PATH_PATTERN.matcher(url.getPath());
        if (matcher.matches()) {
            return matcher.group(2);
        }
        if (url.getQuery() != null) {
            Map<String, String> queryMap = getQueryMap(url.getQuery());
            return queryMap.get(ORG_PAGE_ID);
        }
        return null;
    }
}
