package ru.yandex.direct.core.entity.domain;

import java.net.URL;
import java.util.Map;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import static ru.yandex.direct.core.entity.domain.DomainUtils.getQueryMap;

@ParametersAreNonnullByDefault
public class SubDomainParserForYandexUslugi implements SubDomainParser {

    public static final String USLUGI_PROFILE = "/uslugi/profile/";
    public static final String PROFILE = "/profile/";
    public static final String USLUGI_SEARCH = "/uslugi/search";
    public static final String SEARCH = "/search";
    public static final String WORKER_ID_PARAMETER = "worker_id";

    @Nullable
    public String apply(URL url) {
        if (url.getPath() != null) {
            if (url.getPath().startsWith(USLUGI_PROFILE)) {
                return url.getPath().split("/",5)[3];
            } else if (url.getPath().startsWith(PROFILE)) {
                return url.getPath().split("/", 4)[2];
            } else if ((url.getPath().startsWith(USLUGI_SEARCH) || url.getPath().startsWith(SEARCH))
                    && url.getQuery() != null) {
                Map<String, String> queryMap = getQueryMap(url.getQuery());
                return queryMap.get(WORKER_ID_PARAMETER);
            }
        }
        return null;
    }
}
