package ru.yandex.direct.core.entity.domain;

import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SubDomainParserForYoutubeCom implements SubDomainParser {

    private static final Pattern PATH_PATTERN = Pattern.compile("^/(channel)/([^/]+)");

    public String apply(URL url) {
        if (url.getPath() == null) {
            return null;
        }
        Matcher matcher = PATH_PATTERN.matcher(url.getPath());
        return matcher.find() ? (matcher.group(1) + "-" + matcher.group(2)) : null;
    }
}
