package ru.yandex.direct.core.entity.domain;

import java.net.URL;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class SubDomainParserForZen implements SubDomainParser {
    //считаем что теги и инфу рекламирует сам дзен
    public static final Set<String> RESERVED_WORDS = Set.of("t", "info", "adv");
    public static final String ID = "id";
    public static final String MEDIA = "/media/";
    public static final String USER = "/user/";
    public static final String PROFILE_EDITOR = "/profile/editor/";


    @Nullable
    @Override
    public String apply(URL url) {
        String id = null;
        if (!StringUtils.isEmpty(url.getPath())) {
            String path = url.getPath();
            String[] splitted = path.split("/");
            int index = 1;
            if (splitted.length > 1 && RESERVED_WORDS.contains(splitted[index])) {
                return null;
            }
            if (path.startsWith(MEDIA) || path.startsWith(USER)) {
                index += 1;
            } else if (path.startsWith(PROFILE_EDITOR)) {
                index += 2;
            }
            if (index < splitted.length) {
                if (splitted[index].equals(ID)) {
                    index += 1;
                }
                id = index < splitted.length ? splitted[index] : null;
            }
        }
        return id;
    }
}
