package ru.yandex.direct.core.entity.domain.model;

import java.util.Objects;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class CidAndDomain {

    private final Long cid;
    private final String domain;

    private CidAndDomain(Long cid, String domain) {
        this.cid = Objects.requireNonNull(cid, "cid");
        this.domain = Objects.requireNonNull(domain, "domain");
    }

    @Nonnull
    public static CidAndDomain of(Long cid, String domain) {
        return new CidAndDomain(cid, domain);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        CidAndDomain that = (CidAndDomain) o;

        return cid.equals(that.cid) && domain.equals(that.domain);
    }

    @Override
    public int hashCode() {
        int result = domain.hashCode();
        result = 31 * result + cid.hashCode();
        return result;
    }

    @Nonnull
    public Long getCid() {
        return cid;
    }

    @Nonnull
    public String getDomain() {
        return domain;
    }
}
