package ru.yandex.direct.core.entity.dynamictextadtarget.container;

import java.util.HashSet;
import java.util.Set;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.dynamictextadtarget.model.DynamicTextAdTargetState;
import ru.yandex.direct.dbutil.model.BusinessIdAndShopId;

import static java.util.Arrays.asList;
import static java.util.Collections.emptySet;

@ParametersAreNonnullByDefault
public class DynamicTextAdTargetSelectionCriteria {

    private Set<Long> conditionIds;
    private Set<Long> adGroupIds;
    private Set<Long> campaignIds;
    private Set<BusinessIdAndShopId> businessIdsAndShopIds;
    private Set<DynamicTextAdTargetState> states;

    @Nonnull
    public Set<Long> getConditionIds() {
        return conditionIds == null ? emptySet() : conditionIds;
    }

    public DynamicTextAdTargetSelectionCriteria withConditionIds(@Nullable Set<Long> conditionIds) {
        this.conditionIds = conditionIds;
        return this;
    }

    public DynamicTextAdTargetSelectionCriteria withConditionIds(Long... conditionIds) {
        withConditionIds(new HashSet<>(asList(conditionIds)));
        return this;
    }

    @Nonnull
    public Set<Long> getAdGroupIds() {
        return adGroupIds == null ? emptySet() : adGroupIds;
    }

    public DynamicTextAdTargetSelectionCriteria withAdGroupIds(@Nullable Set<Long> adGroupIds) {
        this.adGroupIds = adGroupIds;
        return this;
    }

    public DynamicTextAdTargetSelectionCriteria withAdGroupIds(Long... adGroupIds) {
        withAdGroupIds(new HashSet<>(asList(adGroupIds)));
        return this;
    }

    @Nonnull
    public Set<Long> getCampaignIds() {
        return campaignIds == null ? emptySet() : campaignIds;
    }

    public DynamicTextAdTargetSelectionCriteria withCampaignIds(@Nullable Set<Long> campaignIds) {
        this.campaignIds = campaignIds;
        return this;
    }

    public DynamicTextAdTargetSelectionCriteria withCampaignIds(Long... adGroupIds) {
        withCampaignIds(new HashSet<>(asList(adGroupIds)));
        return this;
    }

    @Nonnull
    public Set<BusinessIdAndShopId> getBusinessIdsAndShopIds() {
        return businessIdsAndShopIds == null ? emptySet() : businessIdsAndShopIds;
    }

    public DynamicTextAdTargetSelectionCriteria withBusinessIdsAndShopIds(
            @Nullable Set<BusinessIdAndShopId> businessIdsAndShopIds) {
        this.businessIdsAndShopIds = businessIdsAndShopIds;
        return this;
    }

    public DynamicTextAdTargetSelectionCriteria withBusinessIdsAndShopIds(BusinessIdAndShopId... businessIdsAndShopIds) {
        withBusinessIdsAndShopIds(new HashSet<>(asList(businessIdsAndShopIds)));
        return this;
    }

    @Nonnull
    public Set<DynamicTextAdTargetState> getStates() {
        return states == null ? emptySet() : states;
    }

    public DynamicTextAdTargetSelectionCriteria withStates(@Nullable Set<DynamicTextAdTargetState> states) {
        this.states = states;
        return this;
    }

    public DynamicTextAdTargetSelectionCriteria withStates(DynamicTextAdTargetState... states) {
        withStates(new HashSet<>(asList(states)));
        return this;
    }
}
